<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Common;
use App\Models\One_vs_One_Battles;
use App\Models\User;
use Illuminate\Http\Request;
use Exception;

class OneVsOneBattlesController extends Controller
{
    private $folder = "user";
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index(Request $request)
    {
        try {

            $params['user'] = User::latest()->get();
            if ($request->ajax()) {

                $input_search = $request['input_search'];
                $input_start_date = $request['input_start_date'];
                $input_end_date = $request['input_end_date'];
                $input_c_user_id = $request['input_c_user_id'];
                $input_j_user_id = $request['input_j_user_id'];
                $input_status = $request['input_status'];

                $query = One_vs_One_Battles::latest();
                if ($input_search) {
                    $query->where(function ($q) use ($input_search) {
                        $q->where('room_code', 'LIKE', "%{$input_search}%")->orWhere('name', 'LIKE', "%{$input_search}%");
                    });
                }
                if (!empty($input_start_date)) {
                    $query->whereDate('created_at', '>=', date('Y-m-d', strtotime($input_start_date)));
                }
                if (!empty($input_end_date)) {
                    $query->whereDate('created_at', '<=', date('Y-m-d', strtotime($input_end_date)));
                }
                if ($input_c_user_id != 0) {
                    $query->where('c_user_id', $input_c_user_id);
                }
                if ($input_j_user_id != 0) {
                    $query->where('j_user_id', $input_j_user_id);
                }
                if ($input_status != 'all') {
                    $query->where('status', $input_status);
                }
                $data = $query->with('c_user', 'j_user')->latest()->get();

                return DataTables()::of($data)
                    ->addIndexColumn()
                    ->addColumn('action', function ($row) {

                        $battles_delete = __('label.delete_battles');

                        $delete = '<form onsubmit="return confirm(\'' . $battles_delete . '\');" method="POST" action="' . route('admin.one_vs_one_battles.destroy', [$row->id]) . '">
                            <input type="hidden" name="_token" value="' . csrf_token() . '">
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit" class="edit-delete-btn" style="outline: none;"><i class="fa-solid fa-trash-can fa-xl"></i></button></form>';

                        $btn = '<div class="d-flex justify-content-around">';
                        $btn .= '<a href="' . route('admin.one_vs_one_battles.show', [$row->id]) . '" class="edit-delete-btn mr-2">';
                        $btn .= '<i class="fa-solid fa-eye fa-xl"></i>';
                        $btn .= '</a>';
                        $btn .= $delete;
                        $btn .= '</a></div>';
                        return $btn;
                    })
                    ->addColumn('status', function ($row) {
                        if ($row->status == 0) {
                            $showLabel = __('label.draw');
                            return "<button type='button' class='info-btn'>$showLabel</button>";
                        } else if ($row->status == 1) {
                            $showLabel = __('label.completed');
                            return "<button type='button' class='show-btn'>$showLabel</button>";
                        } else {
                            $hideLabel = __('label.not_completed');
                            return "<button type='button' class='hide-btn px-2'>$hideLabel</button>";
                        }
                    })
                    ->rawColumns(['action', 'status'])
                    ->make(true);
            }
            return view('admin.one_vs_one_battles.index', $params);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function destroy($id)
    {
        try {

            One_vs_One_Battles::where('id', $id)->delete();
            return redirect()->route('admin.one_vs_one_battles.index')->with('success', __('label.battles_delete'));
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function show($id)
    {
        try {

            $params['data'] = One_vs_One_Battles::where('id', $id)->with(['c_user', 'j_user'])->first()->toArray();
            if ($params['data']) {

                $params['data']['c_user']['image'] = !empty($params['data']['c_user']['image'])
                    ? $this->common->getImage($this->folder, $params['data']['c_user']['image'])
                    : asset('assets/imgs/default.png');

                $params['data']['j_user']['image'] = !empty($params['data']['j_user']['image'])
                    ? $this->common->getImage($this->folder, $params['data']['j_user']['image'])
                    : asset('assets/imgs/default.png');

                return view('admin.one_vs_one_battles.show', $params);
            } else {
                return redirect()->back()->with('error', __('label.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
